/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing.lexer;

import com.aptana.parsing.lexer.IRange;
import java.text.MessageFormat;

public class Range
implements IRange {
    public static final Range EMPTY = new Range(0, -1);
    private int fStart;
    private int fEnd;

    public Range(int offset) {
        this(offset, offset);
    }

    public Range(int start, int end) {
        this.fStart = start;
        this.fEnd = end;
    }

    public boolean contains(int offset) {
        return this.getStartingOffset() <= offset && offset <= this.getEndingOffset();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range otherRange = (Range)obj;
        return this.getStartingOffset() == otherRange.getStartingOffset() && this.getLength() == otherRange.getLength();
    }

    public int getEndingOffset() {
        return this.fEnd;
    }

    public int getLength() {
        return this.getEndingOffset() - this.getStartingOffset() + 1;
    }

    public int getStartingOffset() {
        return this.fStart;
    }

    public int hashCode() {
        return 31 * this.getStartingOffset() + this.getLength();
    }

    public boolean isEmpty() {
        return this.fEnd < this.fStart;
    }

    public String toString() {
        return MessageFormat.format("[{0},{1}]", this.fStart, this.fEnd);
    }
}

